% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_optimal_grid.R
\name{get_optimal_grid}
\alias{get_optimal_grid}
\title{Get Optimal Grid Assignment}
\usage{
get_optimal_grid(x, y, z)
}
\arguments{
\item{x}{A numeric vector of values representing the first variable.}

\item{y}{A numeric vector of values representing the second variable.}

\item{z}{A numeric vector representing the distribution of the third variable, used to define quantiles for \code{x} and \code{y}.}
}
\value{
A numeric vector of optimal indices that represents the optimal assignment of \code{x} values to \code{y} values.
}
\description{
This function computes an optimal grid assignment between two variables \code{x} and \code{y} based on a third variable \code{z}.
It uses the quantiles of \code{x} and \code{y} to segment the data based on the distribution of \code{z}. Then, it computes the cost of
assigning points from \code{x} to \code{y} by calculating the counts of \code{y} values within quantile ranges of \code{x} and \code{y}, and then solves
the assignment problem using the Hungarian algorithm.
}
\examples{
# Test Case 1: Simple uniform data
x <- rnorm(1000)
y <- rnorm(1000)
z <- sample(1:5, 1000, replace = TRUE)
optimal_assignment <- get_optimal_grid(x, y, z)

# Test Case 2: Data with a skewed distribution
x <- rexp(1000, rate = 1)
y <- rpois(1000, lambda = 2)
z <- sample(1:3, 1000, replace = TRUE)
optimal_assignment <- get_optimal_grid(x, y, z)

}
