% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lmeBM.R
\name{lmeBM}
\alias{lmeBM}
\title{lmeBM}
\usage{
lmeBM(fixed, data, random, covariance = NULL, method = c("REML", "ML"),
  control = list(), keep.data = TRUE)
}
\arguments{
\item{fixed}{This is as specified for \code{\link[nlme]{lme.formula}}.}

\item{data}{This is as specified for \code{\link[nlme]{lme.formula}}.}

\item{random}{This is as specified for \code{\link[nlme]{lme.formula}}.}

\item{covariance}{An optional \code{\link[nlme]{corStruct}} object describing the within-group
covariance structure. In addition to those available in \code{nlme},
\code{\link{covBM}} can be used to incorporate a Brownian motion component, \code{\link{covFracBM}}
can be used to incorporate a fractional Brownian motion component and \code{\link{covIOU}}
can be used to incorporate an integrated Ornstein-Uhlenbeck process in relation to
a continuous variable.}

\item{method}{This is as specified for \code{\link[nlme]{lme.formula}}.}

\item{control}{This is as specified for \code{\link[nlme]{lme.formula}}.}

\item{keep.data}{This is as specified for \code{\link[nlme]{lme.formula}}.}
}
\value{
An object of class "lme" representing the linear mixed effects model fit.
}
\description{
This function is a wrapper for \code{\link[nlme]{lme.formula}} that allows
Brownian motion, fractional Brownian motion or integrated Ornstein-Uhlenbeck
components to be included in linear mixed models, with related parameter
estimates and confidence intervals returned in their natural parameterisation.
}
\examples{
BMmodel<-lmeBM(sqrtcd4~t, data=cd4, random=~t|newpid, covariance=covBM(form=~t|newpid),
							method="ML", control=list(opt="link{nlm}"))
}

