% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chrr_county_data.R
\name{get_chrr_county_data}
\alias{get_chrr_county_data}
\title{Get County-Level County Health Rankings & Roadmaps Data}
\usage{
get_chrr_county_data(
  state,
  county = NULL,
  release_year = NULL,
  refresh = FALSE,
  citation = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{state}{\code{Character}. Specifies the state. May be a full
state name (e.g., \code{"Wisconsin"}), postal abbreviation
(e.g., \code{"WI"}), or two-digit FIPS code (e.g., \code{"55"}).}

\item{county}{\code{Character}. Specifies the county. May be a
county name (e.g., \code{"Dane"}) or a three-digit county FIPS
code (e.g., \code{"025"}). Matching is not case sensitive and
ignores common suffixes such as "County," "Parish," "City,"
"Borough," or similar. If missing, \code{NA}, or \code{"000"},
state-level data are returned.}

\item{release_year}{\code{Numeric}. Specifies the CHR&R release
year. Defaults to the most recent available release year.}

\item{refresh}{\code{Logical}. Indicates whether to force a fresh
download from Zenodo even if cached data are available.
Defaults to \code{FALSE}.}

\item{citation}{\code{Logical}. If \code{TRUE} (default), prints the
appropriate Zenodo DOI for the requested release year which is useful for citation.
Set to \code{FALSE} to suppress DOI output.}

\item{verbose}{\code{Logical}. If \code{TRUE} (default), additional information about the
selected geography is displayed.
Set to \code{FALSE} to return only the requested \code{data.frame}.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame})
containing CHR&R measure values for the specified geography
and release year.

For county-level requests, the tibble includes one row per
measure for the specified county and contains the following columns:
\describe{
\item{state_fips}{Character. Two-digit state FIPS code.}
\item{county_fips}{Character. Three-digit county FIPS code.}
\item{measure_id}{Character. Unique CHR&R measure identifier.}
\item{measure_name}{Character. Measure name.}
\item{description}{Character. Brief measure description.}
\item{raw_value}{Numeric. Reported measure value.}
\item{ci_low}{Numeric. Lower bound of confidence interval, if available.}
\item{ci_high}{Numeric. Upper bound of confidence interval, if available.}
\item{numerator}{Numeric. Measure numerator, if available.}
\item{denominator}{Numeric. Measure denominator, if available.}
\item{years_used}{Character. Years used in calculation of the measure.}
\item{compare_years_text}{Character. Text describing temporal comparison.}
\item{compare_states_text}{Character. Text describing state comparison.}
}

For state-level requests, the structure is identical except that
\code{county_fips} is not included.

The returned tibble represents the full set of CHR&R measures
available for the specified geography and release year.
}
\description{
Returns County Health Rankings & Roadmaps (CHR&R) measure data
for a specified state and (optionally) county and release year.
Data are retrieved from the Zenodo repository and include measure
values and associated metadata.
}
\details{
If a county is specified, county-level data are returned. If the
\code{county} argument is missing, \code{NA}, or \code{"000"},
state-level data are returned instead.
}
\examples{
\donttest{
# County-level example
dane <- get_chrr_county_data("WI", "Dane", 2024)
head(dane)

# State-level example
wi <- get_chrr_county_data("WI", county = NULL, 2024)
head(wi)
}
}
