% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cosimmr_output.R
\name{plot.cosimmr_output}
\alias{plot.cosimmr_output}
\title{Plot different features of an object created from  \code{\link{cosimmr_ffvb}}.}
\usage{
\method{plot}{cosimmr_output}(
  x,
  type = c("isospace", "beta_histogram", "beta_boxplot", "prop_histogram",
    "prop_density", "covariates_plot"),
  obs = 1,
  cov_name = NULL,
  binwidth = 0.05,
  alpha = 0.5,
  title = NULL,
  n_output = 3600,
  source = NULL,
  one_plot = FALSE,
  n_pred = 1000,
  ...
)
}
\arguments{
\item{x}{An object of class \code{cosimmr_output} created via
\code{\link{cosimmr_ffvb}}.}

\item{type}{The type of plot required. Can be one or more of 'isospace', 
'beta_histogram', 'beta_boxplot', 'prob_histogram', 'prob_density', 'covariates_plot'}

\item{obs}{The observation number you wish to plot}

\item{cov_name}{The name of the covariate you wish to plot (for beta and covariates plot)}

\item{binwidth}{The width of the bins for the histogram. Defaults to 0.05}

\item{alpha}{The degree of transparency of the plots. Not relevant for
matrix plots}

\item{title}{The title of the plot.}

\item{n_output}{The number of theta samples you wish to plot with. Defaults to 3600}

\item{source}{The number or name of the source you wish to plot over for 
'covariates_plot', defaults to NULL which means all sources are used}

\item{one_plot}{Whether to plot line covariates plot on one plot. Defaults to FALSE}

\item{n_pred}{Number of points to use when plotting line covariates plot. Defaults to 1000.}

\item{...}{Currently not used}
}
\value{
one or more of 'isospace', 'beta_histogram', 'beta_boxplot', 'prop_histogram', 'prop_density', or 'covariates_plot'
}
\description{
This function allows for 4 different types of plots of the simmr output
created from \code{\link{cosimmr_ffvb}}. The 
types are: plot of beta values
}
\details{
The matrix plot should form a necessary part of any SIMM analysis since it
allows the user to judge which sources are identifiable by the model.
Further detail about these plots is provided in the vignette.
}
\examples{

\donttest{
# A simple example with 10 observations, 2 tracers and 4 sources

# The data
data(geese_data_day1)

# Load into simmr
simmr_1 <- with(
  geese_data_day1,
  cosimmr_load(
    formula = mixtures ~ 1,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)
# Plot
plot(simmr_1)


# FFVB run
simmr_1_out <- cosimmr_ffvb(simmr_1)

plot(simmr_1_out, type = c("isospace", "beta_hist"))
}
}
\seealso{
See  \code{\link{cosimmr_ffvb}} for 
creating objects suitable for this function, and many more examples. See 
also \code{\link{cosimmr_load}} for creating simmr objects, 
\code{\link{plot.cosimmr_input}} for creating isospace plots.
}
\author{
Emma Govan <emmagovan@gmail.com>, Andrew Parnell
}
