% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_coordinates.R
\name{set_coordinates}
\alias{set_coordinates}
\title{Set, create or modify columns with spatial information}
\usage{
set_coordinates(
  .df,
  decimalLatitude = NULL,
  decimalLongitude = NULL,
  geodeticDatum = NULL,
  coordinateUncertaintyInMeters = NULL,
  coordinatePrecision = NULL,
  .keep = "unused"
)
}
\arguments{
\item{.df}{A \code{data.frame} or \code{tibble} that the column should be appended to.}

\item{decimalLatitude}{The latitude in decimal degrees.}

\item{decimalLongitude}{The longitude in decimal degrees.}

\item{geodeticDatum}{The datum or spatial reference system that coordinates
are recorded against (usually "WGS84" or "EPSG:4326"). This is often known
as the Coordinate Reference System (CRS). If your coordinates are from a GPS
system, your data are already using WGS84.}

\item{coordinateUncertaintyInMeters}{(numeric) Radius of the smallest circle
that contains the whole location, given any possible measurement error.
\code{coordinateUncertaintyInMeters} will typically be around \code{30} (metres) if
recorded with a GPS after 2000, or \code{100} before that year.}

\item{coordinatePrecision}{(numeric) The precision that \code{decimalLatitude} and
\code{decimalLongitude} are supplied to. \code{coordinatePrecision} should be no less
than 0.00001 if data were collected using GPS.}

\item{.keep}{Control which columns from \code{.df} are retained in the output.
Note that unlike \code{\link[dplyr:mutate]{dplyr::mutate()}}, which defaults to \code{"all"} this defaults to
\code{"unused"}; i.e. only keeps Darwin Core columns, and not those columns used to
generate them.}
}
\value{
A \code{tibble} with the requested columns added/reformatted.
}
\description{
This function helps format standard location fields like
latitude and longitude point coordinates to a \code{tibble} using Darwin Core
Standard.
}
\details{
In practice this is no different from using \code{mutate()}, but gives some
informative errors, and serves as a useful lookup for how spatial columns are
represented in the Darwin Core Standard.

Example values are:
\itemize{
\item \code{geodeticDatum} should be a valid EPSG code
}
}
\examples{
df <- tibble::tibble(
  scientificName = c("Crinia Signifera", "Crinia Signifera", "Litoria peronii"),
  latitude = c(-35.27, -35.24, -35.83),
  longitude = c(149.33, 149.34, 149.34),
  eventDate = c("2010-10-14", "2010-10-14", "2010-10-14")
  )

# Reformat columns to Darwin Core Standard terms
df |>
  set_coordinates(
    decimalLongitude = longitude,
    decimalLatitude = latitude
    )

}
\seealso{
\code{\link[=set_locality]{set_locality()}} for provided text-based spatial information.
}
