% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence.R
\name{style_sim_seq}
\alias{style_sim_seq}
\title{Calculate stylistic similarity sequence for a single dyad}
\usage{
style_sim_seq(conversation, window_size = 3)
}
\arguments{
\item{conversation}{A data frame representing the conversation}

\item{window_size}{An integer specifying the size of the sliding window}
}
\value{
A list containing the sequence of similarities and the average similarity
}
\description{
This function calculates stylistic similarity over a sequence of conversation exchanges within a single dyad.
}
\examples{
conversation <- data.frame(
  processed_text = c("How are you doing?", "I'm doing great, thanks!",
                     "That's wonderful to hear.", "I'm glad you're doing well.")
)
result <- style_sim_seq(conversation, window_size = 2)
print(result)
}
