% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_multidyads.R
\name{semantic_sim_dyads}
\alias{semantic_sim_dyads}
\title{Calculate semantic similarity for multiple dyads}
\usage{
semantic_sim_dyads(conversations, method = "tfidf", window_size = 3, ...)
}
\arguments{
\item{conversations}{A data frame with columns 'dyad_id', 'speaker', and 'processed_text'}

\item{method}{A character string specifying the method to use: "tfidf", "word2vec", or "glove"}

\item{window_size}{An integer specifying the size of the sliding window}

\item{...}{Additional arguments passed to semantic_similarity}
}
\value{
A list containing the sequence of similarities for each dyad and the overall average similarity
}
\description{
This function calculates semantic similarity over a sequence of conversation exchanges for multiple dyads.
}
\examples{
library(lme4)
convs <- data.frame(
  dyad_id = c(1, 1, 1, 1, 2, 2, 2, 2),
  speaker = c("A", "B", "A", "B", "C", "D", "C", "D"),
  processed_text = c("i love pizza", "me too favorite food",
                     "whats your favorite topping", "enjoy pepperoni mushrooms",
                     "i prefer pasta", "pasta delicious like spaghetti carbonara",
                     "ever tried making home", "yes quite easy make")
)
semantic_sim_dyads(convs, method = "tfidf", window_size = 2)
}
