% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence.R
\name{lex_sim_seq}
\alias{lex_sim_seq}
\title{Calculate lexical similarity sequence for a single dyad}
\usage{
lex_sim_seq(conversation, window_size = 3)
}
\arguments{
\item{conversation}{A data frame representing the conversation}

\item{window_size}{An integer specifying the size of the sliding window}
}
\value{
A list containing the sequence of similarities and the average similarity
}
\description{
This function calculates lexical similarity over a sequence of conversation exchanges within a single dyad.
}
\examples{
conversation <- data.frame(
  processed_text = c("Hello world", "World of programming",
                     "Programming is fun", "Fun world of coding")
)
result <- lex_sim_seq(conversation, window_size = 2)
print(result)
}
