% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation_tests.R
\name{rescue_short_run_channel}
\alias{rescue_short_run_channel}
\title{Rescue short-run channel test}
\usage{
rescue_short_run_channel(
  results_robust,
  lag = 1,
  B = 1000,
  seed = NULL,
  ridge = 0.001,
  oos_start = 0.6,
  verbose = TRUE
)
}
\arguments{
\item{results_robust}{Output from run_complete_factor_analysis_robust()}

\item{lag}{Number of lags for the model (default: 1)}

\item{B}{Number of bootstrap iterations (default: 1000)}

\item{seed}{Random seed for reproducibility (default: NULL)}

\item{ridge}{Ridge regularization parameter (default: 0.001)}

\item{oos_start}{Proportion of data to use for training (default: 0.6)}

\item{verbose}{Logical; print progress and diagnostic information. Default \code{TRUE}.}
}
\value{
List with components:
\describe{
\item{\code{granger_p}}{P-values from Granger causality tests.}
\item{\code{OOS}}{List with out-of-sample RMSE comparison.}
\item{\code{p_values}}{Bootstrap p-values for RMSE differences.}
}
}
\description{
Evaluates the short-run causal relationship from X to Y factors using Granger
causality tests and out-of-sample forecast comparison.
}
\details{
testing. Default is 0.2.
}
