% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/departure_mean.R
\name{departure_mean}
\alias{departure_mean}
\title{Departures from an average}
\usage{
departure_mean(oriTB, sigmaTB, timeName = "time")
}
\arguments{
\item{oriTB}{original dataset (tibble) with time by country values.}

\item{sigmaTB}{result from sigma_convergence called on oriTB.}

\item{timeName}{string with the name of the time variable in oriTB.}
}
\value{
list of tibbles containing  labelled departures from the mean, square difference from the mean,
         and percentage of deviance.
}
\description{
For each country the departure from the average is calculated
and a numerical label is created: -1 if smaller than one standard deviation
from the mean, +1 if above one standard deviation from the mean, 0 otherwise.
}
\examples{

# Example 1
# The original dataset in the format time by countries:
require(tibble)
testTB <- dplyr::tribble(
~time, ~countryA ,  ~countryB,  ~countryC,
2000,     0.8,   2.7,    3.9,
2001,     1.2,   3.2,    4.2,
2002,     0.9,   2.9,    4.1,
2003,     1.3,   2.9,    4.0,
2004,     1.2,   3.1,    4.1,
2005,     1.2,   3.0,    4.0
)

# Calculate sigma_convergence on the original dataset:
mySTB <- sigma_conv(testTB)

# Calculate departures from the average for each country:
resDM <-  departure_mean(oriTB=testTB, sigmaTB=mySTB$res)
names(resDM$res)

# Example 2: Departures from the average for the Eurofound dataset "emp_20_64_MS"
data(emp_20_64_MS)
# Sigma convergence on the original dataset:
mySC <- sigma_conv(emp_20_64_MS)

# Calculate departures from the mean for each country:
resDMeur <- departure_mean(oriTB = emp_20_64_MS, sigmaTB = mySC$res)

# Results for labelled departures from the mean:
resDMeur$res$departures

# Results for square difference from the mean:
resDMeur$res$squaredContrib

# Results for the percentage of deviance:
resDMeur$res$devianceContrib

}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
