% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{launch_ui}
\alias{launch_ui}
\title{Launch the DuckDB UI in your browser}
\usage{
launch_ui(.con)
}
\arguments{
\item{.con}{A valid \code{DBIConnection} object connected to a DuckDB database.
The function will check that the connection is valid before proceeding.}
}
\value{
The function is called for its side effects and does not return a value.
It launches the DuckDB UI and opens it in your default web browser.
}
\description{
The \code{launch_ui()} function installs and launches the DuckDB UI extension
for an active DuckDB database connection. This allows users to interact
with the database via a web-based graphical interface.

Your connection from \code{\link[=create_contoso_duckdb]{create_contoso_duckdb()}} is returned in the list.
}
\details{
The function performs the following steps:
\itemize{
\item Checks that the provided DuckDB connection is valid.
If the connection is invalid, it aborts with a descriptive error message.
\item Installs the \code{ui} extension into the connected DuckDB instance.
\item Calls the \code{start_ui()} procedure to launch the DuckDB UI in your browser.
}

This provides a convenient way to explore and manage DuckDB databases
interactively without needing to leave the R environment.
}
\examples{
\dontrun{
# Connect to DuckDB
db <- create_contoso_duckdb()

# Launch the DuckDB UI
launch_ui(db$con)

# Clean up
DBI::dbDisconnect(db$con, shutdown = TRUE)
}

}
\seealso{
\itemize{
\item \code{\link[=create_contoso_duckdb]{create_contoso_duckdb()}} for creating example Contoso datasets in DuckDB.
\item \code{\link[DBI:dbConnect]{DBI::dbConnect()}} and \code{\link[DBI:dbDisconnect]{DBI::dbDisconnect()}} for managing DuckDB connections.
\item \code{\link[duckdb:duckdb]{duckdb::duckdb()}} for creating a DuckDB driver instance.
}
}
