% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_oauth_credentials}
\alias{get_oauth_credentials}
\title{Perform an OAuth credential exchange to obtain a visitor's OAuth access token.}
\usage{
get_oauth_credentials(
  connect,
  user_session_token,
  requested_token_type = NULL,
  audience = NULL
)
}
\arguments{
\item{connect}{A Connect R6 object.}

\item{user_session_token}{The content visitor's session token. This token
can only be obtained when the content is running on a Connect server. The token
identifies the user who is viewing the content interactively on the Connect server.
Read this value from the HTTP header: \code{Posit-Connect-User-Session-Token}}

\item{requested_token_type}{Optional. The requested token type. If unset, will
default to \code{urn:ietf:params:oauth:token-type:access_token}. Otherwise, this can
be set to \code{urn:ietf:params:aws:token-type:credentials} for AWS integrations or
\code{urn:posit:connect:api-key} for Connect API Key integrations.}

\item{audience}{Optional. The GUID of an OAuth integration associated with
this piece of content.}
}
\value{
The OAuth credential exchange response.
}
\description{
Perform an OAuth credential exchange to obtain a visitor's OAuth access token.
}
\details{
Please see https://docs.posit.co/connect/user/oauth-integrations/#obtaining-a-viewer-oauth-access-token
for more information.
}
\examples{
\dontrun{
library(connectapi)
library(plumber)
client <- connect()

#* @get /do
function(req) {
  user_session_token <- req$HTTP_POSIT_CONNECT_USER_SESSION_TOKEN
  credentials <- get_oauth_credentials(client, user_session_token)

  # ... do something with `credentials$access_token` ...

  "done"
}
}

}
\seealso{
\code{\link[=get_integrations]{get_integrations()}}, \code{\link[=get_oauth_content_credentials]{get_oauth_content_credentials()}}
}
