% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{accuracy.cvforecast}
\alias{accuracy.cvforecast}
\alias{accuracy.cpforecast}
\title{Accuracy measures for a cross-validation model and a conformal prediction model}
\usage{
\method{accuracy}{cvforecast}(
  object,
  x,
  CV = TRUE,
  period = NULL,
  measures = interval_measures,
  byhorizon = FALSE,
  ...
)

\method{accuracy}{cpforecast}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"cvforecast"} or \code{"cpforecast"}.}

\item{x}{An optional numerical vector containing actual values of the same
length as \code{mean} in \code{object}.}

\item{CV}{If \code{TRUE}, the cross-validation forecast accuracy will be returned.}

\item{period}{The seasonal period of the data.}

\item{measures}{A list of accuracy measure functions to compute (such as
\link{point_measures} or \link{interval_measures}).}

\item{byhorizon}{If \code{TRUE}, accuracy measures will be calculated for each
individual forecast horizon \code{h} separately.}

\item{...}{Additional arguments depending on the specific measure.}
}
\value{
A matrix giving mean out-of-sample forecast accuracy measures.
}
\description{
Return range of summary measures of the out-of-sample forecast accuracy.
If \code{x} is given, the function also measures test set forecast accuracy.
If \code{x} is not given, the function only produces accuracy measures on
validation set.
}
\details{
The measures calculated are:
\itemize{
\item ME: Mean Error
\item MAE: Mean Absolute Error
\item MSE: Mean Squared Error
\item RMSE: Root Mean Squared Error
\item MPE: Mean Percentage Error
\item MAPE: Mean Absolute Percentage Error
\item MASE: Mean Absolute Scaled Error
\item RMSSE: Root Mean Squared Scaled Error
\item winkler_score: Winkler Score
\item MSIS: Mean Scaled Interval Score
}
}
\examples{
# Simulate time series from an AR(2) model
library(forecast)
series <- arima.sim(n = 200, list(ar = c(0.8, -0.5)), sd = sqrt(1))

# Cross-validation forecasting with a rolling window
far2 <- function(x, h, level) {
  Arima(x, order = c(2, 0, 0)) |>
    forecast(h = h, level)
}
fc <- cvforecast(series, forecastfun = far2, h = 3, level = 95,
                 forward = TRUE, initial = 1, window = 50)

# Out-of-sample forecast accuracy on validation set
accuracy(fc, measures = point_measures, byhorizon = TRUE)
accuracy(fc, measures = interval_measures, level = 95, byhorizon = TRUE)

# Out-of-sample forecast accuracy on test set
accuracy(fc, x = c(1, 0.5, 0), measures = interval_measures,
         level = 95, byhorizon = TRUE)

}
\seealso{
\code{\link{point_measures}}, \code{\link{interval_measures}}
}
