% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.interpretation_set}
\alias{plot.interpretation_set}
\title{Plot a diagram of the valid options for an interpretation_set object}
\usage{
\method{plot}{interpretation_set}(x, extra_boundaries = NULL, ...)
}
\arguments{
\item{x}{An \code{interpretation_set} object.}

\item{extra_boundaries}{A vector of numerical values specifying the position for displaying
additional boundaries, not specified in the \code{interpretation_set}.
May optionally be named values; if named, the names will be labelled
on the plot axis. See Details for information on specifying locations.}

\item{...}{Further arguments passed to and from methods.}
}
\description{
Produces a diagram that illustrates the set of pairs of lower and upper
confidence limits that are valid for a given
\code{\link{interpretation_set}} object. The output is presented as a set of
regions in different colours with boxes either within regions or spanning
them to illustrate where the lower and upper confidence limits sit. The
options are labelled alphabetically, and presented in the order in which
their associated interpretations should be provided in the
\code{interpretation_set}.
}
\details{
Additional boundaries can be displayed using the \code{extra_boundaries}
parameter. This can be helpful if you want to show a position that is
of some practical relevance, but is not defined as a boundary for the
purposes of the \code{interpretation_set}. The boundaries specified by the
\code{interpretation_set} are plotted with spacing 1 and are centred about
0: for an even number of boundaries the central pair of boundaries will be
at -0.5 and +0.5; for an odd number of boundaries the central one will be
at 0, and the next ones (if any) will be at -1 and +1, and so on.

Plots use the current R Graphics Palette, so you may wish to set that to
something attractive before plotting. See \code{?palette}.
}
\examples{
# Set a nice colour scheme
grDevices::palette(c("#FF671F99", "#F2A90099", "#0085CA99"))
# Plot the pre-defined interpretations_equivalence object with an additional
#   central boundary to illustrate where the actual null point is.
plot(interpretations_equivalence, extra_boundaries = c("Actual null" = 0))

}
