% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformers.R
\name{with_subsampling}
\alias{with_subsampling}
\title{Create stochastic log-likelihood with subsampling}
\usage{
with_subsampling(loglike, data, subsample_size, replace = FALSE)
}
\arguments{
\item{loglike}{Base log-likelihood function. Should accept theta and data.}

\item{data}{Observations (vector, matrix, or data.frame)}

\item{subsample_size}{Number of observations to sample per evaluation}

\item{replace}{Sample with replacement (logical, default: FALSE)}
}
\value{
Transformed log-likelihood function
}
\description{
Transforms a log-likelihood function to use only a random subsample of
observations. Useful for stochastic gradient ascent on large datasets.
}
\examples{
\donttest{
# Original likelihood uses all data
data <- rnorm(10000, mean = 5, sd = 2)

loglike <- function(theta, obs = data) {
  sum(dnorm(obs, mean = theta[1], sd = theta[2], log = TRUE))
}

# Stochastic version uses random subsample
loglike_stoch <- with_subsampling(
  loglike,
  data = data,
  subsample_size = 100
)

# Each call uses different random subsample
loglike_stoch(c(5, 2))
loglike_stoch(c(5, 2))  # Different value
}
}
