% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateVarCov.R
\name{calculateVarCov}
\alias{calculateVarCov}
\title{calculateVarCov: Estimate variance and covariance components of assessee p S_p and mean assessment scores i nested in assessees S_iINp,
and determine the error scores S_delta}
\usage{
calculateVarCov(mydata, n)
}
\arguments{
\item{mydata}{A dataframe containing columns ID, Type, Score (numeric)}

\item{n}{A vector containing for each Type the number of scores or assessments, e.g. averages, requirements.}
}
\value{
A list containing the observed variances, covariances and errors scores
}
\description{
calculateVarCov: Estimate variance and covariance components of assessee p S_p and mean assessment scores i nested in assessees S_iINp,
and determine the error scores S_delta
}
\examples{
varcov <- calculateVarCov(mydata, c("A"=3, "B"=3, "C"=2))
varcov$S_p
varcov$S_iINp
varcov$S_delta
}
