% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODEs.R
\name{EPSturmLiouville2}
\alias{EPSturmLiouville2}
\title{Sturm–Liouville eigenproblem with homogeneous Dirichlet boundary conditions}
\usage{
EPSturmLiouville2(
  p,
  q,
  w,
  x,
  nev = NULL,
  normalize = TRUE,
  return_matrices = FALSE,
  check_inputs = TRUE,
  tol_uniform = 1e-12
)
}
\arguments{
\item{p}{Function \code{p(x)} or numeric vector at midpoints.}

\item{q}{Function \code{q(x)} or numeric vector at nodes.}

\item{w}{Function \code{w(x)} or numeric vector at nodes.}

\item{x}{Numeric grid including endpoints (\code{x[1]=a}, \code{x[n+1]=b}); must be uniform.}

\item{nev}{Integer number of eigenpairs to return (smallest); default all interior modes.}

\item{normalize}{Logical; if \code{TRUE}, scale interior eigenvectors so that
\eqn{\sum_i h\,w_i\,u_i^2 = 1}. Default \code{TRUE}.}

\item{return_matrices}{Logical; if \code{TRUE}, also return \code{K} and \code{W}. Default \code{FALSE}.}

\item{check_inputs}{Logical; run basic checks (uniform grid, positivity of \code{p}, \code{w}). Default \code{TRUE}.}

\item{tol_uniform}{Tolerance for uniform‑grid check. Default \code{1e-12}.}
}
\value{
A list with
\itemize{
  \item \code{values}: eigenvalues (ascending).
  \item \code{vectors_interior}: interior eigenvectors (matrix \code{(n-1) x k}).
  \item \code{vectors_full}: full eigenfunctions with zero endpoints (matrix \code{(n+1) x k}).
  \item \code{x}, \code{h}, \code{nev_used}.
  \item \code{K}, \code{W} if \code{return_matrices=TRUE}.
}
}
\description{
Solves
\deqn{-\frac{d}{dx}\left(p(x)\,y'(x)\right) + q(x)\,y(x) = \lambda\, w(x)\,y(x)}
on \eqn{[a,b]} with \eqn{y(a)=0} and \eqn{y(b)=0}. The equation is discretised
on the interior nodes of a \strong{uniform} grid and assembled into
matrices \code{K} and \code{W} so that \code{K u = lambda W u}.
The problem is reduced to a symmetric standard eigenproblem and solved.
}
\details{
Coefficients may be given as functions or numeric vectors:
\itemize{
  \item \code{p}: function on midpoints or numeric vector of length \code{length(x)-1} (midpoints).
  \item \code{q}, \code{w}: functions on nodes or numeric vectors of length \code{length(x)} (nodes).
}

Homogeneous Dirichlet conditions are enforced by construction: unknowns
are interior only; the returned full eigenfunctions have zero endpoints.
}
\examples{
# p=1, q=0, w=1 on [0, pi]  -> eigenvalues ~ 1^2, 2^2, 3^2, ...
a <- 0; b <- pi; n <- 200
x <- seq(a, b, length.out = n+1)
pfun <- function(s) 1            # scalars are accepted; will be replicated
qfun <- function(s) 0
wfun <- function(s) 1
ep <- EPSturmLiouville2(pfun, qfun, wfun, x, nev = 4, normalize = TRUE)
round(ep$values, 3)              # ~ c(1, 4, 9, 16)

}
