% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcATHBstandard.R
\name{calcATHBstandard}
\alias{calcATHBstandard}
\title{PMV based on Adaptive Thermal Heat Balance Framework for the Standard Model}
\usage{
calcATHBstandard(trm, ta, tr, vel, rh, met)
}
\arguments{
\item{trm}{- Running mean outdoor temperature in [degree C]}

\item{ta}{- a numeric value presenting air temperature in [degree C]}

\item{tr}{- a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{- a numeric value presenting air velocity in [m/s]}

\item{rh}{- a numeric value presenting relative humidity [\%]}

\item{met}{- a numeric value presenting metabolic rate in [met]}
}
\value{
\code{calcATHBstandard} PMV value adapted through the ATHB approach with standard model
}
\description{
\code{calcATHBstandard} calculates the PMV based on adaptive thermal heat balance framework

based on the newest version (2022)
}
\details{
aliases athb ATHB
}
\examples{
calcATHBstandard(20, 25, 25, .1, 50, 1.1)
}
\references{
Schweiker & Wagner (2015) <doi:10.1016/j.buildenv.2015.08.018>
Schweiker (2022) <doi:10.1111/ina.13018>
}
\seealso{
see also \code{\link{calcComfInd}}, \code{link{calcATHBpts}}, \code{link{calcATHBset}},

\code{link{calcATHBpmv2015}}
}
\author{
Code implemented in to R by Shaomi Rahman. Further contribution by Marcel Schweiker.
}
