% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combi_score.R
\name{combi_score}
\alias{combi_score}
\title{Compute the combi score using glm(link='binomial') models and optionally classifies the samples.}
\usage{
combi_score(
  data,
  Models,
  Metrics,
  Positive_class = 1,
  Negative_class = 0,
  deal_NA = "impute",
  classify = F
)
}
\arguments{
\item{data}{a data.frame returned by load_data().}

\item{Models}{a list of glm() objects returned by roc_reports().}

\item{Metrics}{a list of data.frame objects containing ROC metrics, returned by roc_reports().}

\item{Positive_class}{a numeric or a character that specifies the label of the samples that will be classified as positives}

\item{Negative_class}{a numeric or a character that specifies the label of the samples that will be classified as negatives}

\item{deal_NA}{a character that specifies how to treat missing values. With 'impute' NAs of each marker are substituted with the median of that given marker values. With 'remove' the whole observations containing a NA are removed'.}

\item{classify}{a boolean that specifies if the samples will be classified.}
}
\value{
a data.frame containing the combi scores (classify=F) or predicted class of each sample (classify=T), for each marker/combination in Models
}
\description{
A function that applies the previously calculated models to a dataset to compute combi scores and optionally classify the samples.
}
\details{
This function  can take as input datasets loaded with load_data(). They MUST contain all the markers of the combinations used to train the models.
}
\examples{
\dontrun{
demo_data # combiroc built-in demo data (proteomics data from Zingaretti et al. 2012 - PMC3518104)
demo_unclassified_data # combiroc built-in unclassified demo data

combs <- combi(data= demo_data, signalthr=450, combithr=1, case_class='A')  # compute combinations

reports <- roc_reports(data= demo_data, markers_table= combs,
                       selected_combinations= c(1,11,15),
                       single_markers=c('Marker1', 'Marker2'), case_class='A') # train logistic
                                                                               # regression models


# To fit the models an retrieve the combi scores (predicted probabilities).

score_data <- combi_score(data= demo_unclassified_data, Models= reports$Models,
                             Metrics= reports$Metrics)

# To classify new samples with logistic regression models.

classified_data <- combi_score(data= demo_unclassified_data,
                               Models= reports$Models,Metrics= reports$Metrics,
                               Positive_class=1, Negative_class=0, classify=TRUE)

classified_data  # show samples classified using Logistic regression models
}
}
