% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayerhanck.R
\name{bayerhanck}
\alias{bayerhanck}
\title{Joint Test-Statistic for the Null of Non-Cointegration}
\usage{
bayerhanck(formula, data, lags = 1, trend = "const", test = "all")
}
\arguments{
\item{formula}{An object of class \code{\link[stats]{formula}} to describe the model.}

\item{data}{An optional data frame containing the variables in the model.}

\item{lags}{Number of lags to be included.}

\item{trend}{Type of deterministic component to be included. "none" for no deterministic,
"const" for a constant and "trend" for a constant plus trend.}

\item{test}{Selection of tests to choose from. Choices are either "ej", for \code{\link{englegranger}}
and \code{\link{johansen}}, or "all", for \code{\link{englegranger}}, \code{\link{johansen}},
\code{\link{banerjee}} and \code{\link{boswijk}}.}
}
\value{
\code{bayerhanck} returns an object of classes \code{"bhtest"} and \code{"list"}.

The function \code{summary} is used to print a summary, which includes the test statistics and p-values
for the underlying tests, as well as the test statistic and p-value for the Bayer Hanck Test.

An object of class \code{"bhtest"} is a \code{"list"} containing, inter alia, the components:

\item{bh.test}{the test statistic of the Bayer Hanck Test.}
\item{bh.pval}{the p-Value of the Bayer Hanck Test.}
\item{test.stat}{the test statistics of the underlying tests.}
\item{pval.stat}{the p-values of the underlying tests.}
}
\description{
Produces a joint test-statistic for the null of non-cointegration, aggregating
various cointegration tests.
}
\examples{
# Luetkepohl (2007): Economic data from West Germany
data(lutkepohl_e1)
bayerhanck(linvestment ~ lincome + lconsumption, data = lutkepohl_e1)
bayerhanck(linvestment ~ lincome + lconsumption, data = lutkepohl_e1, lags = 4)


\dontshow{if (requireNamespace("MTS", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# World Almanac and Book of Facts (1975): Monthly simple returns of the stocks of IBM,
# Coca Cola and S&P Composite index
try({
  data("mts-examples", package = "MTS")
  bayerhanck(sp ~ ibm + ko, data = ibmspko)
}, silent = TRUE)


\dontshow{\}) # examplesIf}
}
\references{
Bayer, C. and Hanck, C. (2013). Combining non-cointegration tests. \emph{Journal of Time Series Analysis}, 34(1), 83 -- 95. \doi{10.1111/j.1467-9892.2012.00814.x}
}
