
<!-- README.md is generated from README.Rmd. Please edit that file -->

# colorednoise <img src='man/figures/hex.png' align="right" height="125" />

[![CRAN_version](https://www.r-pkg.org/badges/version/colorednoise)](https://cran.r-project.org/package=colorednoise)
[![Coverage
Status](https://img.shields.io/codecov/c/github/japilo/colorednoise/master.svg)](https://app.codecov.io/github/japilo/colorednoise?branch=master)
[![Download_count](https://cranlogs.r-pkg.org/badges/grand-total/colorednoise)](https://CRAN.R-project.org/package=colorednoise)
[![Paper_doi](https://img.shields.io/badge/doi-10.1111/oik.06438-orange.svg)](https://doi.org/10.1111/oik.06438)

## Overview

Many populations that change over time are *temporally autocorrelated*,
which means that the random noise in each timestep is correlated to that
of the previous timestep. Instead of uncorrelated white noise, these
populations are governed by blue noise (negatively autocorrelated) or
red noise (positively autocorrelated.)

The colorednoise package allows you to simulate colored noise as well as
populations whose behavior is governed by colored noise.

## Installation

You can install the latest version of colorednoise from github with:

``` r
# install.packages("devtools")
devtools::install_github("japilo/colorednoise")
```

## Example

Here are plots of blue- and red-noise populations generated by the
`matrix_model` function.

``` r
library(colorednoise)
set.seed(7927)
pop_blue <- matrix_model(
  data = list(
    mean = matrix(c(0.6687097, 0.2480645, 0.6687097, 0.4335484), ncol=2),
    sd = matrix(c(0.34437133, 0.08251947, 0.34437133, 0.10898160), ncol=2),
    autocorrelation = matrix(rep(-0.4, 4), ncol=2)
  ), timesteps = 100, initialPop = c(100, 100)
)
pop_red <- matrix_model(
  data = list(
    mean = matrix(c(0.6687097, 0.2480645, 0.6687097, 0.4335484), ncol=2),
    sd = matrix(c(0.34437133, 0.08251947, 0.34437133, 0.10898160), ncol=2),
    autocorrelation = matrix(rep(0.4, 4), ncol=2)
  ), timesteps = 100, initialPop = c(100, 100)
)
ggplot(pop_blue, aes(x = timestep, y = total)) + geom_line(col="blue") + ylim(0, 6000)
```

![](man/figures/README-example-1.png)<!-- -->

``` r
ggplot(pop_red, aes(x = timestep, y = total)) + geom_line(col="red") + ylim(0, 6000)
```

![](man/figures/README-example-2.png)<!-- -->
