% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat_omega.R
\name{sumstat_omega}
\alias{sumstat_omega}
\title{Summary Statistic: Omega}
\usage{
sumstat_omega(
  name = "omega",
  min_win = 100,
  max_win = 1000,
  grid = 1000,
  binary = "automatic",
  transformation = identity
)
}
\arguments{
\item{name}{The name of the summary statistic. When simulating a model,
the value of the statistics are written to an entry of the returned list
with this name. Summary statistic names must be unique in a model.}

\item{min_win}{The minimum distance from the grid point that a SNP must have
to be included in the calculation of omega.}

\item{max_win}{The maximum distance from the grid point that a SNP must have
to be included in the calculation of omega.}

\item{grid}{The number of points for which omega is calculated on each
locus. Should be significantly lower than the locus length.}

\item{binary}{The path of the binary for OmegaPlus. If set to "automatic",
coala will try to find a binary called "OmegaPlus" using the PATH
environment variable.}

\item{transformation}{An optional function for transforming the results
of the statistic. If specified, the results of the transformation are
returned instead of the original values.}
}
\value{
A data frame listing of locus, genetic position and the
calculated omega value.
}
\description{
Calculates the Omega Statistic introduced by
Kim & Nielsen (2004) from the simulated data. The statistic is sensitive for
hard selective sweeps. To calculate
the statistic, coala relies on the command line program
\href{http://sco.h-its.org/exelixis/web/software/omegaplus/index.html}{OmegaPlus},
which needs to be downloaded and compiled manually in order to use the
statistic.
}
\examples{
\dontrun{
model <- coal_model(20, 1, 50000) +
  feat_recombination(50) +
  feat_mutation(1000) +
  feat_selection(strength_A = 1000, time = 0.03) +
  sumstat_omega()
stats <- simulate(model)
plot(stats$omega$omega, type = "l")}
}
\references{
Linkage disequilibrium as a signature of selective sweeps.
Y. Kim and R. Nielsen (2004). Genetics, 167, 1513-1524.

OmegaPlus: a scalable tool for rapid detection of selective
sweeps in whole-genome datasets.
N. Alachiotis, A. Stamatakis and P. Pavlidis (2012).
Bioinformatics Vol. 28 no. 17 2012, pages 2274-2275
doi:10.1093/bioinformatics/bts419
}
\seealso{
To create a demographic model: \code{\link{coal_model}}

To calculate this statistic from data: \code{\link{calc_sumstats_from_data}}

Other summary statistics: 
\code{\link{sumstat_dna}()},
\code{\link{sumstat_file}()},
\code{\link{sumstat_four_gamete}()},
\code{\link{sumstat_ihh}()},
\code{\link{sumstat_jsfs}()},
\code{\link{sumstat_mcmf}()},
\code{\link{sumstat_nucleotide_div}()},
\code{\link{sumstat_seg_sites}()},
\code{\link{sumstat_sfs}()},
\code{\link{sumstat_tajimas_d}()},
\code{\link{sumstat_trees}()}
}
\concept{summary statistics}
