% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{p_equiv_two_sample}
\alias{p_equiv_two_sample}
\title{p-Value for two-sample equivalency}
\usage{
p_equiv_two_sample(n, m, t1, t2)
}
\arguments{
\item{n}{the size of the qualification sample}

\item{m}{the size of the acceptance sample}

\item{t1}{the test statistic described above. May be a vector.}

\item{t2}{the test statistic described above. May be a vector.}
}
\value{
a vector of p-Values of the same length as t1 and t2
}
\description{
Calculates the p-Value for a two-sample acceptance test.
This test considers the sample size of the qualification
sample (\code{n}) and the acceptance sample (\code{m}).

Two test statistics are required:

t1 = (X_mean - Y_min) / S

t2 = (X_mean - Y_mean) / S

Where:
\itemize{
\item X_mean is the mean of the qualification sample
\item S is the standard deviation of the qualification sample
\item Y_min is the minimum from the acceptance sample
\item Y_mean is the mean of the acceptance sample
}
}
