% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{iso_equiv_two_sample}
\alias{iso_equiv_two_sample}
\title{Calculate t1 and t2 pairs that have the same p-Value}
\usage{
iso_equiv_two_sample(n, m, alpha, t1max, t2max, n_points)
}
\arguments{
\item{n}{the size of the qualification sample}

\item{m}{the size of the equivalency sample}

\item{alpha}{the desired p-value}

\item{t1max}{the maximum value of t1 (only approximate)}

\item{t2max}{the maximum value of t2 (only approximate)}

\item{n_points}{the number of returned points is twice n_points}
}
\value{
A \code{data.frame} with values of t1 and t2
}
\description{
Calculates pairs of t1 and t2 values, which have the same p-value for the
two-sample equivalency test. See \code{\link[=p_equiv_two_sample]{p_equiv_two_sample()}}.
}
\details{
The values t1 and t2 are based on the transformation:

t1 = (X_mean - Y_min) / S

t2 = (X_mean - Y_mean) / S

Where:
\itemize{
\item X_mean is the mean of the qualification sample
\item S is the standard deviation of the qualification sample
\item Y_min is the minimum from the acceptance sample
\item Y_mean is the mean of the acceptance sample
}
}
\examples{
\donttest{
if(requireNamespace("tidyverse")){
  library(cmstatrExt)
  library(tidyverse)
  curve <- iso_equiv_two_sample(24, 8, 0.05, 4, 1.5, 10)
  curve

  curve \%>\%
    ggplot(aes(x = t1, y = t2)) +
      geom_path() +
      ggtitle("Acceptance criteria for alpha=0.05")
}
}

}
\references{
Kloppenborg, S. (2023). Lot acceptance testing using sample mean and
extremum with finite qualification samples. Journal of Quality Technology,
https://doi.org/10.1080/00224065.2022.2147884
}
\seealso{
\code{\link[=p_equiv_two_sample]{p_equiv_two_sample()}}, \code{\link[=k_equiv_two_sample]{k_equiv_two_sample()}}
}
