% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mpfs.R
\name{get_mpfs}
\alias{get_mpfs}
\title{Access Medicare Physician Fee Schedule}
\usage{
get_mpfs(year, storage_path, keep_downloads = TRUE, locality)
}
\arguments{
\item{year}{integer (min = 14; max = 20) indicating MPFS database year}

\item{storage_path}{path to storing downloaded files (temporarily if
`keep_downloads` equals `FALSE`)}

\item{keep_downloads}{if `TRUE`, stores compressed CMS data to prevent
re-downloading; if `FALSE`, deletes intermediate data after loading into R}

\item{locality}{7-digit HCFS identification number; if not specified,
will return entire MPFS database (all localities)}
}
\value{
MPFS database for respective year and localities (data frame)
}
\description{
Use the CMS API to download the MPFS database for any year between
2014 and 2020, inclusive.
}
\examples{
\dontrun{
# get entire MPFS database for 2020
mpfs20 <- get_mpfs(20, storage_path = 'storage', keep_downloads = TRUE)

# get 2019 MPFS database only for carrier 15202 and locality 00
mpfs19 <- get_mpfs(19, storage_path = 'storage', locality = '1520200')
}
}
