% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrimination.R
\name{discrimination}
\alias{discrimination}
\title{Item discrimination}
\usage{
discrimination(x, wt = NULL, itemscores = NULL, administered = NULL)
}
\arguments{
\item{x}{a data frame or matrix of scored data.}

\item{wt}{a vector with total weights. Default is \code{NULL}.}

\item{itemscores}{a numeric vector indicating all the possible scores for all items.
If \code{NULL}, possible scores will be derived from data.}

\item{administered}{a logical matrix indicating which items were administered.
The dimensions should be the same as \code{x}. If \code{NULL} all items
are considered administered.}
}
\value{
a list.
}
\description{
Estimates item discrimination of a corrected matrix or
data frame.
}
\examples{
# No weights
ex <- correct(x = dichodata, key = dichokey, navalue = NA)
discrimination(ex)


# With weights
set.seed(1919)
wt <- sample(x = 1:4, size = nrow(dichodata), replace = TRUE)
discrimination(ex,wt = wt)

}
\keyword{stats}
