% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{imports_post}
\alias{imports_post}
\title{Create a new import configuration}
\usage{
imports_post(
  name,
  sync_type,
  is_outbound,
  source = NULL,
  destination = NULL,
  schedule = NULL,
  notifications = NULL,
  parent_id = NULL,
  next_run_at = NULL,
  time_zone = NULL,
  hidden = NULL
)
}
\arguments{
\item{name}{string required. The name of the import.}

\item{sync_type}{string required. The type of sync to perform; one of Dbsync, AutoImport, GdocImport, and GdocExport.}

\item{is_outbound}{boolean required.}

\item{source}{list optional. A list containing the following elements: 
\itemize{
\item remoteHostId integer, 
\item credentialId integer, 
\item additionalCredentials array, Array that holds additional credentials used for specific imports. For DB Syncs, the first element is an SSL private key credential id, and the second element is the corresponding public key credential id.
}}

\item{destination}{list optional. A list containing the following elements: 
\itemize{
\item remoteHostId integer, 
\item credentialId integer, 
\item additionalCredentials array, Array that holds additional credentials used for specific imports. For DB Syncs, the first element is an SSL private key credential id, and the second element is the corresponding public key credential id.
}}

\item{schedule}{list optional. A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Days of the week, based on numeric value starting at 0 for Sunday. Mutually exclusive with scheduledDaysOfMonth
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Deprecated in favor of scheduled minutes.
\item scheduledDaysOfMonth array, Days of the month it is scheduled on, mutually exclusive with scheduledDays.
}}

\item{notifications}{list optional. A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on. Defaults to user's preferences.
\item failureOn boolean, If failure email notifications are on. Defaults to user's preferences.
}}

\item{parent_id}{integer optional. Parent id to trigger this import from}

\item{next_run_at}{string optional. The time of the next scheduled run.}

\item{time_zone}{string optional. The time zone of this import.}

\item{hidden}{boolean optional. The hidden status of the item.}
}
\value{
A list containing the following elements:
\item{name}{string, The name of the import.}
\item{syncType}{string, The type of sync to perform; one of Dbsync, AutoImport, GdocImport, and GdocExport.}
\item{source}{list, A list containing the following elements: 
\itemize{
\item remoteHostId integer, 
\item credentialId integer, 
\item additionalCredentials array, Array that holds additional credentials used for specific imports. For DB Syncs, the first element is an SSL private key credential id, and the second element is the corresponding public key credential id.
\item name string, 
}}
\item{destination}{list, A list containing the following elements: 
\itemize{
\item remoteHostId integer, 
\item credentialId integer, 
\item additionalCredentials array, Array that holds additional credentials used for specific imports. For DB Syncs, the first element is an SSL private key credential id, and the second element is the corresponding public key credential id.
\item name string, 
}}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Days of the week, based on numeric value starting at 0 for Sunday. Mutually exclusive with scheduledDaysOfMonth
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Deprecated in favor of scheduled minutes.
\item scheduledDaysOfMonth array, Days of the month it is scheduled on, mutually exclusive with scheduledDays.
}}
\item{notifications}{list, A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on. Defaults to user's preferences.
\item failureOn boolean, If failure email notifications are on. Defaults to user's preferences.
}}
\item{parentId}{integer, Parent id to trigger this import from}
\item{id}{integer, The ID for the import.}
\item{isOutbound}{boolean, }
\item{jobType}{string, The job type of this import.}
\item{syncs}{array, An array containing the following fields: 
\itemize{
\item id integer, 
\item source object, 
\item destination object, 
\item advancedOptions object, 
}}
\item{state}{string, }
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{runningAs}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{nextRunAt}{string, The time of the next scheduled run.}
\item{timeZone}{string, The time zone of this import.}
\item{hidden}{boolean, The hidden status of the item.}
\item{archived}{string, The archival status of the requested item(s).}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
}
\description{
Create a new import configuration
}
