% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_standard.R
\name{ci_standard}
\alias{ci_standard}
\title{For given observed response vector \eqn{y}, compute
the standard \eqn{1 - \alpha} confidence interval}
\usage{
ci_standard(a, X, y, alpha, sig = NULL)
}
\arguments{
\item{a}{The vector used to specify the parameter of interest
\eqn{\theta = a^{\top} \beta}}

\item{X}{The known \eqn{n \times p} design matrix, with linearly
independent columns}

\item{y}{The \eqn{n}-vector of observed responses}

\item{alpha}{\eqn{1 - \alpha} is the coverage
probability of the standard confidence interval}

\item{sig}{Standard deviation of the random error.
If a value is not specified then, provided that \eqn{n-p \ge 30},
\code{sig} is estimated from the data.}
}
\value{
If \eqn{\sigma} is provided then a data frame of the lower and upper
endpoints of the standard \eqn{1 - \alpha} confidence interval
for \eqn{\theta}. If \eqn{\sigma}
is not provided then, as long as \eqn{n-p \ge 30}, a data frame of the
lower and upper endpoints of
an approximation to this confidence interval.
}
\description{
If \eqn{\sigma} is provided then compute the standard \eqn{1 - \alpha}
confidence interval for \eqn{\theta}. If \eqn{\sigma}
is not provided
then, as long as \eqn{n-p \ge 30}, replace \eqn{\sigma} by its estimate
to compute an approximate \eqn{1 - \alpha} confidence interval for \eqn{\theta}.
}
\details{
Suppose that \deqn{y = X \beta + \varepsilon,}
where \eqn{y} is a random \eqn{n}-vector of responses, \eqn{X}
is a known \eqn{n \times p} matrix with linearly independent columns,
\eqn{\beta} is an unknown parameter \eqn{p}-vector, and
\eqn{\varepsilon \sim N(0, \, \sigma^2 \, I)}, with \eqn{\sigma^2} assumed known.
Suppose that the parameter of interest is \eqn{\theta = a^{\top} \beta}.
The R function \code{ci_standard} computes the standard \eqn{1 - \alpha}
confidence interval for \eqn{\theta}.

The example below is described in Discussion 5.8 on
p.3426 of Kabaila and Giri (2009). This example is obtained
by extracting a \eqn{2 \times 2} factorial data set from the
\eqn{2^3} factorial data set described in Table 7.5
of Box et al. (1963).
}
\examples{
y <- c(87.2, 88.4, 86.7, 89.2)
x1 <- c(-1, 1, -1, 1)
x2 <- c(-1, -1, 1, 1)
X <- cbind(rep(1, 4), x1, x2, x1*x2)
a <- c(0, 2, 0, -2)
ci_standard(a, X, y, 0.05, sig = 0.8)

}
\references{
Box, G.E.P., Connor, L.R., Cousins, W.R., Davies, O.L., Hinsworth, F.R., Sillitto, G.P. (1963)
The Design and Analysis
of Industrial Experiments, 2nd edition, reprinted. Oliver and Boyd, London.

Kabaila, P. and Giri, K. (2009) Confidence intervals in regression utilizing
prior information.  Journal of Statistical Planning and Inference, 139,
3419 - 3429.
}
