% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnn.R
\name{conv}
\alias{conv}
\title{Convolutional layer}
\usage{
conv(
  n_kernels = NULL,
  kernel_size = NULL,
  stride = NULL,
  padding = NULL,
  dilation = NULL,
  bias = NULL,
  activation = NULL,
  normalization = NULL,
  dropout = NULL
)
}
\arguments{
\item{n_kernels}{(int) amount of kernels in this layer}

\item{kernel_size}{(int or tuple) size of the kernels in this layer. Use a tuple if the kernel size isn't equal in all dimensions}

\item{stride}{(int or tuple) stride of the kernels in this layer. NULL sets the stride equal to the kernel size. Use a tuple if the stride isn't equal in all dimensions}

\item{padding}{(int or tuple) zero-padding added to both sides of the input. Use a tuple if the padding isn't equal in all dimensions}

\item{dilation}{(int or tuple) dilation of the kernels in this layer. Use a tuple if the dilation isn't equal in all dimensions}

\item{bias}{(boolean) if TRUE, adds a learnable bias to the kernels of this layer}

\item{activation}{(string) activation function that is used after this layer. The following activation functions are supported: "relu", "leaky_relu", "tanh", "elu", "rrelu", "prelu", "softplus", "celu", "selu", "gelu", "relu6", "sigmoid", "softsign", "hardtanh", "tanhshrink", "softshrink", "hardshrink", "log_sigmoid"}

\item{normalization}{(boolean) if TRUE, batch normalization is used after this layer}

\item{dropout}{(float) dropout rate of this layer. Set to 0 for no dropout}
}
\value{
S3 object of class \code{"conv" "citolayer"}
}
\description{
creates a 'conv' 'citolayer' object that is used by \code{\link{create_architecture}}.
}
\details{
This function creates a 'conv' 'citolayer' object that is passed to the \code{\link{create_architecture}} function.
The parameters that aren't assigned here (and are therefore still NULL) are filled with the default values passed to \code{\link{create_architecture}}.
}
\seealso{
\code{\link{create_architecture}}
}
\author{
Armin Schenk
}
