% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.cirls.R
\name{logLik.cirls}
\alias{logLik.cirls}
\title{Log-Likelihood for a fitted \code{cirls} object}
\usage{
\method{logLik}{cirls}(object, df = "edf", ...)
}
\arguments{
\item{object}{A \code{cirls} object.}

\item{df}{The type of degrees of freedom to assign to the log-Likelihood. Default to expected degrees of freedom. See \code{\link[=edf]{edf()}}.}

\item{...}{Arguments to be passed to \link[=edf]{edf} to compute degrees of freedom.}
}
\value{
A numeric value of class \code{logLik} with attributes \code{df} (degrees of freedom, see details) and \code{nobs} (number of observations used in the estimation).
}
\description{
Extracts the log-likelihood for a fitted \code{cirls} object to be typically used by \link[stats:AIC]{AIC}.
}
\details{
The argument \code{df} provide the type of degrees of freedom attributed to the returned log-likelihood value. This is typically used in the computation of \link[stats:AIC]{AIC} and \link[stats:AIC]{BIC} and changing the degrees of freedom can ultimately change the values of the information criteria. By default, the expected number of freedom given the constraints is used. See \link[=edf]{edf} for details on the computation and for the returned types of degrees of freedom.
}
\seealso{
\link[=edf]{edf} to compute expected degrees of freedom.
}
