% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildCmat.R
\name{buildCmat}
\alias{buildCmat}
\title{Build a constraint matrix}
\usage{
buildCmat(mf, constr = NULL, Cmat = NULL, lb = 0, ub = Inf)
}
\arguments{
\item{mf}{A \link[stats:model.frame]{model.frame} or a list of variables.}

\item{constr}{A formula specifying constraints.}

\item{Cmat}{A named list of constraint matrices where names should be found among the terms in \code{mf}.}

\item{lb, ub}{Vector or list of vectors containing constraint bounds. If a vector, is used as default bounds for terms with no specified bounds. If a named list, is matched to \code{Cmat} to provide corresponding bounds.}
}
\value{
A list with containing elements \code{Cmat}, \code{lb} and \code{ub} containing the full constraint matrix, lower and upper bounds for the model specified in argument \code{mf}. \code{Cmat} additionally include an attribute called \code{terms} which maps constraints represented in the matrix to individual terms in the model.
}
\description{
Function building a full constraint matrix from a list of constraint matrices and/or a formula providing specific constraints. Mainly used internally by \link[=cirls.fit]{cirls.fit}.
}
\details{
This function is called internally by \code{cirls.fit} whenever \code{Cmat} is not a matrix, and provides a way to specify constraints without having to build a full constraint matrix beforehand. It uses the model frame in \code{mf} to match specific constraints to the right columns in the design matrix.

The argument \code{constr} provides a simple way to specify potentially complex constraints. It is a formula of the form \code{~ shape(x, ...)} where \code{shape} specifies the constraint and \code{x} the term in \code{mf} to which it applies. Internally, the formula will look for a function named \code{shapeConstr} to be called on variable \code{x} (which allows for several columns). The \code{...} represent potential additional arguments for the \code{shapeConstr} function. For the list of available constraints and how to create new ones, see \strong{upcoming}.

The argument \code{Cmat} is used to provide a named list of constraint matrices, where names should correspond to terms in \code{mf}. This allows providing custom constraint matrices to specific terms that wouldn't be available through \code{constr}. Names in \code{Cmat} can include several terms, which should be separated by a \verb{;}, for instance \verb{x1;x2}. Although not mandatory, elements in \code{Cmat} can have attributes \code{lb}, \code{ub} and \code{vars} to provide lower and upper bounds, and term names, respectively.

\code{lb} and \code{ub} are meant to be used in conjunction with \code{Cmat}. If a simple value or vector, they will be used as default values for elements in \code{Cmat} for which no bounds is specified in its attributes. If lists, they provide bounds for constraint matrices in \code{Cmat}. In this case, all the names in \code{Cmat} should be found in \code{lb} and \code{ub}.

Note that both \code{constr} and \code{Cmat} can be used at the same time, and neither is mandatory. If both are \code{NULL}, an empty constraint matrix will be returned.
}
\examples{
####### Upcoming

}
