% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_ci_diff.R
\name{ci_prop_diff_ha}
\alias{ci_prop_diff_ha}
\title{Anderson-Hauck Confidence Interval for Difference in Proportions}
\usage{
ci_prop_diff_ha(x, by, conf.level = 0.95, data = NULL)
}
\arguments{
\item{x}{(\code{binary}/\code{numeric}/\code{logical})\cr
vector of a binary values, i.e. a logical vector, or numeric with values \code{c(0, 1)}}

\item{by}{(\code{string}) \cr A character or factor vector with exactly two unique levels
identifying the two groups to compare. Can also be a column name if a data
frame provided in the \code{data} argument.}

\item{conf.level}{(\verb{scalar numeric}) \cr a scalar in (0,1) indicating the confidence level. Default is 0.95}

\item{data}{(\code{data.frame}) \cr Optional data frame containing the variables specified in \code{x} and \code{by}.}
}
\value{
An object containing the following components:

\item{n}{The number of responses for each group}
\item{N}{The total number in each group}
\item{estimate}{The point estimate of the difference in proportions}
\item{conf.low}{Lower bound of the confidence interval}
\item{conf.high}{Upper bound of the confidence interval}
\item{conf.level}{The confidence level used}
\item{method}{Anderson-Hauck Confidence Interval}
}
\description{
Anderson-Hauck Confidence Interval for Difference in Proportions
}
\details{
The confidence interval is given by:

\deqn{(\hat{p}_1 - \hat{p}_2) \pm \left[ \frac{1}{2 \min(n_1, n_2)} + z \sqrt{ \frac{\hat{p}_1 (1 - \hat{p}_1)}{n_1 - 1} + \frac{\hat{p}_2 (1 - \hat{p}_2)}{n_2 - 1} } \right]}.
}
\examples{
responses <- expand(c(9, 3), c(10, 10))
arm <- rep(c("treat", "control"), times = c(10, 10))

# Calculate 95\% confidence interval for difference in proportions
ci_prop_diff_ha(x = responses, by = arm)
}
\references{
Hauck WW, Anderson S. (1986) A comparison of large-sample confidence interval methods for the difference of two binomial probabilities The American Statistician 40(4). p.318-322.
\href{https://www.lexjansen.com/wuss/2016/127_Final_Paper_PDF.pdf}{Constructing Confidence Intervals for the Differences of Binomial Proportions in SAS}
}
