% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_fun.R
\name{record_ggplot}
\alias{record_ggplot}
\title{Record a ggplot expression}
\usage{
record_ggplot(ggplot_expression, strict = 2)
}
\arguments{
\item{ggplot_expression}{The entire \code{{ggplot2}} expression to be recorded.}

\item{strict}{An optional integer argument controlling what is treated as a failure:
\itemize{
\item \code{1}: Catches only errors.
\item \code{2}: Catches errors and warnings (the default).
\item \code{3}: Catches errors, warnings, and messages.
}}
}
\value{
A \code{chronicle} object. When printed, it will display the plot if successful
or an error plot if it failed.
}
\description{
\code{record_ggplot} captures a complete \code{{ggplot2}} expression, evaluates it, and
creates a \code{chronicle} object. It uses a robust \code{tryCatch} and \code{withCallingHandlers}
pattern to reliably capture errors, warnings, and messages.

To trigger all conditions, including rendering-time warnings and messages, it
forces a full render of the plot. This is achieved safely by opening a null
graphics device (\code{pdf(NULL)}), scheduling its closure with \code{on.exit(dev.off())},
and then printing the plot. This guarantees that the temporary device is always
closed, even if an error occurs, preventing any side effects on the user's
active graphics session.
}
