% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available_data.R
\name{available_data}
\alias{available_data}
\title{Available data}
\usage{
available_data(
  web_link = "https://cida.usgs.gov/thredds/dodsC/macav2metdata_daily_future",
  verbose = TRUE
)
}
\arguments{
\item{web_link}{A web link to the api data source you want to read (character)}

\item{verbose}{Should the api outputs be combined with internal metadata? (logical)}
}
\value{
Data.frame of requested data
}
\description{
Using the default web link, this package retrieves daily gridded data sets of General Circulation Model
(GCM) runs clipped to areas of interest and returns a data frame of the
file names and they're storage paths. Each of these data sets represent
a single GCM, climate variable and Representative Concentration Pathway (RCP)
from 1950 to 2099. The 1950 to 2005 portion of this time period represents
historical data while the 2006 to 2099 portion represents modeled data. 
The original data sets may be found at
\url{http://thredds.northwestknowledge.net:8080/thredds/reacch_climate_CMIP5_aggregated_macav2_catalog.html}
}
