% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sb_growth_parameter.R
\name{read_sb_growth_parameter}
\alias{read_sb_growth_parameter}
\title{Read LAI images at several time points}
\usage{
read_sb_growth_parameter(img_files, img_dates, target_res)
}
\arguments{
\item{img_files}{character vector providing the file paths of at least two
georeferenced images for the study location. Dates of image capture need to
be defined in \code{img_dates} respectively.}

\item{img_dates}{POSIXct vector of dates corresponding to the images supplied in
\code{img_files} respectively.
To prevent timezone issues use UTC timezone \code{tz = "UTC"}.}

\item{target_res}{desired spatial resolution. \code{target_res} should be
equal to or larger than the actual resolution of the images expressed in
meters.}
}
\value{
\CRANpkg{terra}::\code{SpatRast} with a layer for each input layer. Each layer
is named according to the \code{img_dates}.
The output \code{SpatRast} is suitable for input in \code{calc_r_x0()}
}
\description{
Read LAI images at several time points
}
\examples{
epidemic_onset_param <-
  read_sb_growth_parameter(img_files = list.files(system.file("extdata", "uav_img",
                                                              package = "cercospoRa"),
                                                 pattern = ".tif",
                                                 full.names = TRUE),
                           img_dates = as.POSIXct(c("2022-06-14",
                                                    "2022-06-28"),
                                                  tz = "UTC"),
                           target_res = 10)
}
