% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdfinvsim.R
\name{cdfinv.sim}
\alias{cdfinv.sim}
\title{Computation of confidence intervals via simulations and CDF inversion}
\usage{
cdfinv.sim(
  DISTR,
  PARAM,
  STAT,
  lpb = -10000,
  upb = 10000,
  bound = "two-sided",
  alpha = 0.05,
  tolb = 1e-06,
  tol = 1e-06,
  seed = 1,
  numsim = 1e+05,
  nsamp = 1,
  stat.func = mean,
  ...
)
}
\arguments{
\item{DISTR}{name of distribution (in R) from which each datum is sampled}

\item{PARAM}{name of distribution parameter for which we are computing an interval estimate}

\item{STAT}{observed value of the chosen statistic}

\item{lpb}{lower bound of search interval}

\item{upb}{upper bound of search interval}

\item{bound}{one of "two-sided", "lower", or "upper"}

\item{alpha}{the confidence coefficient is 1 - alpha}

\item{tolb}{search interval bound offset value}

\item{tol}{convergence tolerance for uniroot function}

\item{seed}{random number generator seed}

\item{numsim}{number of simulated datasets}

\item{nsamp}{sample size for each simulated dataset}

\item{stat.func}{pointer to function computing the statistic for each dataset}

\item{...}{additional arguments for DISTR's cdf function}
}
\value{
A list with interval bounds and associated cdf values.
\itemize{
  \item DISTR - The distribution name (as given in R)
  \item PARAM - The parameter name (as given in R)
  \item STAT - The observed statistic value
  \item bound - The interval bound(s)
  \item q - The cdf quantile(s) associated with the interval bound(s)
}
}
\description{
cdfinv.sim() returns one- or two-sided confidence interval estimates.
}
\author{
Peter E. Freeman, \email{pfreeman@cmu.edu}
}
