% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_functions_v2.R
\name{pred.cbass}
\alias{pred.cbass}
\title{Generate chain of latent normal random variables for a given X, for values saved in 'mod'}
\usage{
pred.cbass(mod, X, nburn = 0, nsub = NULL)
}
\arguments{
\item{mod}{CBASS model list}

\item{X}{matrix of covariates of same size / makeup as that used to create mod. If matrix not scaled to the unit interval, then it will be}

\item{nburn}{Number of samples to burn from the chain in mod, default 0}

\item{nsub}{Number of samples to subset to, default to those stored in mod}
}
\value{
An array of latent variables, nsub by nrow(X) by d
}
\description{
Generate chain of latent normal random variables for a given X, for values saved in 'mod'
}
\examples{
set.seed(1)
n <- 100;  d <- 3
X <- matrix(runif(n*2, 0, 1), ncol=2)
mu <- scale(X)
bound <- qnorm(1/d^(1/(d-1)))
mu <- cbind(bound, mu)
z <- mu
z[,-1] <- rnorm(length(mu[,-1]), mu[,-1], 1)
y <- apply(z, 1, which.max)
mod <- fit.cbass(X, y, max.int=1, max.basis=10, nmcmc=1e3, nburn=500, nthin=10)
pred.chain <- pred.cbass(mod, X)
mu.hat <- apply(pred.chain, 2:3, mean)
round(p.mu(mu.hat[1,]), 3)
}
