% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_utils.R
\name{short_position}
\alias{short_position}
\title{Simplify Operation Path}
\usage{
short_position(allowed_positions, n)
}
\arguments{
\item{allowed_positions}{Character vector of operations to simplify}

\item{n}{Integer, size of the permutation ring (used for modular reduction)}
}
\value{
Character vector of simplified operations
}
\description{
Removes redundant operations from a path: cancels inverse pairs ("1"+"2",
"3"+"3"), reduces chains of shifts modulo n, and simplifies blocks
between reverses.
}
\examples{
short_position(c("1", "2"), n = 5)
short_position(c("3", "3"), n = 5)
short_position(c("1", "1", "1", "1", "1"), n = 5)
}
