% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_path_bfs.R
\name{find_path_bfs}
\alias{find_path_bfs}
\title{Find Path via BFS Highways}
\usage{
find_path_bfs(
  start_state,
  final_state,
  k,
  bfs_levels = 500L,
  bfs_n_hubs = 7L,
  bfs_n_random = 3L,
  distance_method = "manhattan",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{start_state}{Integer vector, the starting permutation state}

\item{final_state}{Integer vector, the target permutation state}

\item{k}{Integer, parameter for reverse operations}

\item{bfs_levels}{Integer, depth of sparse BFS from each side (default 500)}

\item{bfs_n_hubs}{Integer, top-degree nodes per BFS level (default 7)}

\item{bfs_n_random}{Integer, random nodes per BFS level (default 3)}

\item{distance_method}{Character, "manhattan" or "breakpoints" (default "manhattan")}

\item{verbose}{Logical, print progress (default TRUE)}

\item{...}{Additional arguments passed to find_path_iterative}
}
\value{
List with path, found, cycles, bfs_info
}
\description{
Builds BFS highway trees from start and final states, finds the closest
pair of hub states (one from each highway), then uses find_path_iterative
to connect them. Assembles the full path:
bfs(start -> hub_s) + iterative(hub_s -> hub_f) + inverted_bfs(final -> hub_f)
}
