% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_combination_in_states.R
\name{find_combination_in_states}
\alias{find_combination_in_states}
\title{Find a State in Reachable States Table}
\usage{
find_combination_in_states(reachable_states_start, search_state)
}
\arguments{
\item{reachable_states_start}{Data frame with V-columns and metadata}

\item{search_state}{Integer vector, the state to search for}
}
\value{
Data frame row with state and metadata columns, or NULL if not found
}
\description{
Searches for a specific permutation state in a reachable states table
and returns the first matching row with metadata.
}
\examples{
df <- data.frame(V1 = c(1, 2), V2 = c(2, 1), operation = c("1", "2"),
                 step = c(1, 2), combo_number = c(1, 1))
find_combination_in_states(df, c(2, 1))
}
