% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celestial.R
\name{find_closest_to_coords}
\alias{find_closest_to_coords}
\title{Find Closest State to Target Coordinates}
\usage{
find_closest_to_coords(reachable_states, target_coords, v_cols)
}
\arguments{
\item{reachable_states}{Data frame with columns theta, phi,
omega_conformal, and V-columns for state}

\item{target_coords}{List with component \code{z} (complex number)}

\item{v_cols}{Character vector of V-column names}
}
\value{
Single-row data frame of the closest state (with angular_distance column added)
}
\description{
Searches a table of reachable states for the state whose celestial
coordinates are closest to a target coordinate set.
}
\examples{
# Typically used with output from get_reachable_states
# find_closest_to_coords(states_df, target_coords, paste0("V", 1:n))
}
