% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_ops_doc.R
\name{apply_operations}
\alias{apply_operations}
\title{Apply Sequence of Operations}
\arguments{
\item{state}{Integer vector representing the current permutation state}

\item{operations}{Character vector of operations ("1"/"L", "2"/"R", "3"/"X")}

\item{k}{Integer, parameter for reverse operations}

\item{coords}{Optional list of current celestial coordinates. If NULL,
starts from zero coordinates.}
}
\value{
List with components:
\item{state}{Integer vector after all operations applied}
\item{coords}{List of final celestial coordinates (nL, nR, nX, theta, phi, omega_conformal)}
}
\description{
Applies a sequence of shift and reverse operations to a permutation state.
Operations can be specified as "1"/"L" (shift left), "2"/"R" (shift right),
or "3"/"X" (reverse prefix). Tracks celestial coordinates.
}
\examples{
result <- apply_operations(1:10, c("1", "3", "2"), k = 4)
result$state

# Using letter codes
result <- apply_operations(1:20, c("L", "X", "R"), k = 4)
result$state
}
