% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{simulate_bounds}
\alias{simulate_bounds}
\title{Simulate bounds}
\usage{
simulate_bounds(obj, bounds, nsim = 1000)
}
\arguments{
\item{obj}{Object as returned by \link{analyze_graph}}

\item{bounds}{Object as returned by \link{optimize_effect_2}}

\item{nsim}{Number of simulation replicates}
}
\value{
A data frame with columns: objective, bound.lower, bound.upper
}
\description{
Run a simple simulation based on the bounds. For each simulation, sample the set of counterfactual probabilities 
from a uniform distribution, translate into a multinomial distribution, and then compute the objective and the 
bounds in terms of the observable variables.
}
\examples{
b <- initialize_graph(graph_from_literal(X -+ Y, Ur -+ X, Ur -+ Y))
obj <- analyze_graph(b, constraints = NULL, effectt = "p{Y(X = 1) = 1} - p{Y(X = 0) = 1}")
bounds <- optimize_effect_2(obj)
simulate_bounds(obj, bounds, nsim = 5)
}
