% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translation-modules.R
\name{create_response_function}
\alias{create_response_function}
\title{Translate regular DAG to response functions}
\usage{
create_response_function(graph)
}
\arguments{
\item{graph}{An \link[igraph]{aaa-igraph-package} object that represents a
directed acyclic graph that contains certain edge attributes. 
 The shiny app returns a graph in this format and \link{initialize_graph} 
 will add them to a regular igraph object with sensible defaults.}
}
\value{
A list of functions representing the response functions
}
\description{
Translate regular DAG to response functions
}
\examples{
### confounded exposure and outcome
b <- initialize_graph(igraph::graph_from_literal(X -+ Y, Ur -+ X, Ur -+ Y))
create_response_function(b)
}
