% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge-manipulation.R
\name{reposition_tier}
\alias{reposition_tier}
\title{Move a Tier Relative to Another in Knowledge}
\usage{
reposition_tier(kn, tier, before = NULL, after = NULL, by_index = FALSE)
}
\arguments{
\item{kn}{A \code{Knowledge} object.}

\item{tier}{The tier to move (label or index, honouring \code{by_index}).}

\item{before}{Exactly one of these must be supplied and must identify
another existing tier.}

\item{after}{Exactly one of these must be supplied and must identify
another existing tier.}

\item{by_index}{If \code{TRUE}, treat \code{order} as the positions instead of
labels. Defaults to \code{FALSE}.}
}
\value{
The updated \code{Knowledge} object.
}
\description{
Move a Tier Relative to Another in Knowledge
}
\examples{
# Move one tier relative to another
data(tpc_example)

kn <- knowledge(
  head(tpc_example),
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    oldage ~ starts_with("old")
  )
)

kn <- reorder_tiers(kn, c("youth", "child", "oldage"))
print(kn)
}
\seealso{
Other knowledge functions: 
\code{\link{+.Knowledge}()},
\code{\link{add_exogenous}()},
\code{\link{add_tier}()},
\code{\link{add_to_tier}()},
\code{\link{add_vars}()},
\code{\link{as_bnlearn_knowledge}()},
\code{\link{as_pcalg_constraints}()},
\code{\link{as_tetrad_knowledge}()},
\code{\link{convert_tiers_to_forbidden}()},
\code{\link{deparse_knowledge}()},
\code{\link{forbid_edge}()},
\code{\link{get_tiers}()},
\code{\link{knowledge}()},
\code{\link{knowledge_to_caugi}()},
\code{\link{remove_edge}()},
\code{\link{remove_tiers}()},
\code{\link{remove_vars}()},
\code{\link{reorder_tiers}()},
\code{\link{require_edge}()},
\code{\link{seq_tiers}()},
\code{\link{unfreeze}()}
}
\concept{knowledge}
\concept{knowledge functions}
