% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\title{Plot Method for causalDisco Objects}
\arguments{
\item{x}{An object to plot (class \link{knowledge} or \link{disco}).}

\item{...}{Additional arguments passed to class-specific plot methods and to \code{\link[caugi:plot]{caugi::plot()}}.}
}
\value{
Invisibly returns the input object. The primary effect is the generated plot.
}
\description{
This is the generic \code{plot()} function for objects of class \link{knowledge}
or \link{disco}. It dispatches to the class-specific plotting methods
\code{\link[=plot.Knowledge]{plot.Knowledge()}} and \code{\link[=plot.Disco]{plot.Disco()}}.
}
\examples{
data(tpc_example)
kn <- knowledge(
  tpc_example,
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    old ~ starts_with("old")
  )
)
plot(kn)

cd_tges <- tges(engine = "causalDisco", score = "tbic")
disco_cd_tges <- disco(data = tpc_example, method = cd_tges, knowledge = kn)
plot(disco_cd_tges)

}
\seealso{
\code{\link[=plot.Knowledge]{plot.Knowledge()}}, \code{\link[=plot.Disco]{plot.Disco()}}, \code{\link[caugi:plot]{caugi::plot()}}
}
