% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge-conversions.R
\name{knowledge_to_caugi}
\alias{knowledge_to_caugi}
\title{Convert Knowledge to Caugi}
\usage{
knowledge_to_caugi(kn)
}
\arguments{
\item{kn}{A \code{knowledge} object.}
}
\value{
A list with the \link[caugi:caugi]{caugi::caugi} object alongside information.
}
\description{
Converts a \code{Knowledge} object to a \link[caugi:caugi]{caugi::caugi} object used for plotting.
}
\examples{
data(tpc_example)
kn <- knowledge(
  tpc_example,
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    old ~ starts_with("old")
  ),
  child_x1 \%-->\% youth_x3
)
cg <- knowledge_to_caugi(kn)

}
\seealso{
Other knowledge functions: 
\code{\link{+.Knowledge}()},
\code{\link{add_exogenous}()},
\code{\link{add_tier}()},
\code{\link{add_to_tier}()},
\code{\link{add_vars}()},
\code{\link{as_bnlearn_knowledge}()},
\code{\link{as_pcalg_constraints}()},
\code{\link{as_tetrad_knowledge}()},
\code{\link{convert_tiers_to_forbidden}()},
\code{\link{deparse_knowledge}()},
\code{\link{forbid_edge}()},
\code{\link{get_tiers}()},
\code{\link{knowledge}()},
\code{\link{remove_edge}()},
\code{\link{remove_tiers}()},
\code{\link{remove_vars}()},
\code{\link{reorder_tiers}()},
\code{\link{reposition_tier}()},
\code{\link{require_edge}()},
\code{\link{seq_tiers}()},
\code{\link{unfreeze}()}
}
\concept{knowledge}
\concept{knowledge functions}
