% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-tetrad.R
\name{install_tetrad}
\alias{install_tetrad}
\title{Install Tetrad GUI}
\usage{
install_tetrad(
  version = getOption("causalDisco.tetrad.version"),
  dir = NULL,
  force = FALSE,
  quiet = FALSE,
  temp_dir = FALSE
)
}
\arguments{
\item{version}{Character; the Tetrad version to install. Default is
\code{getOption("causalDisco.tetrad.version")}.}

\item{dir}{Character; the directory where the JAR should be installed. If
\code{NULL} (default), the function uses the cache directory defined by
\code{getOption("causalDisco.tetrad_cache")}. The directory will be created
if it does not exist.}

\item{force}{Logical; if \code{TRUE}, forces re-download even if the JAR already
exists. Default is \code{FALSE}.}

\item{quiet}{Logical; if \code{FALSE}, shows progress and messages about
downloading and checksum verification. Default is \code{FALSE}.}

\item{temp_dir}{Logical; if \code{TRUE}, installs the JAR in a temporary directory
instead of the cache. Default is \code{FALSE}.}
}
\value{
Invisibly returns the full path to the installed Tetrad JAR.
}
\description{
Downloads and installs the Tetrad GUI JAR file from
\href{https://repo1.maven.org/maven2/io/github/cmu-phil/tetrad-gui/}{Maven Central}.
It downloads the specified version of the Tetrad GUI JAR and its corresponding SHA256 checksum file, and saves them
in the specified directory (or cache). If the JAR already exists and \code{force = FALSE}, it will skip downloading.
}
\details{
In line with \href{https://cran.r-project.org/web/packages/policies.html}{CRAN policies} this function will only
return messages and not throw warnings/errors if the installation fails (e.g. due to no internet connection),
and return \code{NULL}.
}
\examples{
\dontrun{
# Install default version in cache directory
install_tetrad()

# Install a specific version and force re-download
install_tetrad(version = "7.6.10", force = TRUE)

# Install in a temporary directory
install_tetrad(temp_dir = TRUE)

# Install quietly (suppress messages)
install_tetrad(quiet = TRUE)
}

}
