% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{f1_score}
\alias{f1_score}
\title{F1 score}
\usage{
f1_score(truth, est, type = c("adj", "dir"))
}
\arguments{
\item{truth}{A \link[caugi:caugi]{caugi::caugi} object representing the truth graph.}

\item{est}{A \link[caugi:caugi]{caugi::caugi} object representing the estimated graph.}

\item{type}{Character string specifying the comparison type:
\itemize{
\item \code{"adj"}: adjacency comparison.
\item \code{"dir"}: orientation comparison conditional on shared adjacencies.
}}
}
\value{
A numeric in [0,1].
}
\description{
Computes F1 score from two \link[caugi:caugi]{caugi::caugi} objects.
It converts the \link[caugi:caugi]{caugi::caugi} objects to adjacency matrices and computes
F1 score as \eqn{2 \cdot TP/(2 \cdot TP + FP + FN)}, where \code{TP} are truth positives,
\code{FP} are false positives, and \code{FN} are false negatives. If \code{TP + FP + FN = 0}, \code{1} is returned.
Only supports \link[caugi:caugi]{caugi::caugi} objects with these edge types present \verb{-->}, \verb{<-->}, \verb{---} and no edge.
}
\examples{
cg1 <- caugi::caugi(A \%-->\% B + C)
cg2 <- caugi::caugi(B \%-->\% A + C)
f1_score(cg1, cg2, type = "adj")
f1_score(cg1, cg2, type = "dir")

}
\seealso{
Other metrics: 
\code{\link{confusion}()},
\code{\link{evaluate}()},
\code{\link{false_omission_rate}()},
\code{\link{fdr}()},
\code{\link{g1_score}()},
\code{\link{npv}()},
\code{\link{precision}()},
\code{\link{recall}()},
\code{\link{reexports}},
\code{\link{specificity}()}
}
\concept{metrics}
