% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{evaluate}
\alias{evaluate}
\title{Evaluate Causal Graph Estimates}
\usage{
evaluate(truth, est, metrics = "all")
}
\arguments{
\item{truth}{truth \link[caugi:caugi]{caugi::caugi} object.}

\item{est}{Estimated \link[caugi:caugi]{caugi::caugi} object.}

\item{metrics}{List of metrics, see details. If \code{metrics = "all"}, all available metrics are computed.}
}
\value{
A data.frame with one column for each computed metric. Adjacency metrics are prefixed with "adj_",
orientation metrics are prefixed with "dir_", other metrics do not get a prefix.
}
\description{
Computes various metrics to evaluate the difference between estimated
and truth causal graph. Designed primarily for assessing the
performance of causal discovery algorithms.

Metrics are supplied as a list with three slots: \code{$adj}, \code{$dir}, and \code{$other}.
\describe{
\item{\code{$adj}}{Metrics applied to the adjacency confusion matrix (see \code{\link[=confusion]{confusion()}}).}
\item{\code{$dir}}{Metrics applied to the conditional orientation confusion matrix (see \code{\link[=confusion]{confusion()}}).}
\item{\code{$other}}{Metrics applied directly to the adjacency matrices without computing confusion matrices.}
}

Adjacency confusion matrix and conditional orientation confusion matrix only works for
\link[caugi:caugi]{caugi::caugi} objects with these edge types present \verb{-->}, \verb{<-->}, \verb{---} and no edge.
}
\examples{
cg1 <- caugi::caugi(A \%-->\% B + C)
cg2 <- caugi::caugi(B \%-->\% A + C)
evaluate(cg1, cg2)
evaluate(
  cg1,
  cg2,
  metrics = list(
    adj = c("precision", "recall"),
    dir = c("f1_score"),
    other = c("shd")
  )
)

}
\seealso{
Other metrics: 
\code{\link{confusion}()},
\code{\link{f1_score}()},
\code{\link{false_omission_rate}()},
\code{\link{fdr}()},
\code{\link{g1_score}()},
\code{\link{npv}()},
\code{\link{precision}()},
\code{\link{recall}()},
\code{\link{reexports}},
\code{\link{specificity}()}
}
\concept{metrics}
